Imports System
Imports System.Runtime.Serialization
Imports System.IO
Imports System.Collections

'
' This class collects memento objects and decides when the occurrence
' of a milestone necessitates the creation of a new memento object.
'
<Serializable()> Public Class MilestoneMementoManager
    Private mementos As New Hashtable()
    Private model As GameModel

    '
    ' Constructor
    '
    ' model - The GameModel objct that this objedt will work with
    Public Sub New(ByVal model As GameModel)
        Me.model = model
    End Sub 'New

    '
    ' A GameModel object calls this method to notify this object that
    ' the player's character has achieved a milestone.  If no memento
    ' with the given description has already been created then this
    ' object requests the GameModel object to create one.
    '
    Public Sub snapshotMilestone(ByVal description As String)
        If mementos(description) Is Nothing Then
            mementos(description) = model.CreateMemento(description)
        End If
    End Sub 'snapshotMilestone 

    ' Array of memento objects.
    Public ReadOnly Property MilestoneMementos() As IMilestoneMemento()
        Get
            Dim a(mementos.Count) As IMilestoneMemento
            mementos.CopyTo(a, 0)
            Return CType(a, MilestoneMemento())
        End Get
    End Property

    '
    ' Restore the game's state from the given memento object.
    '
    Public Sub RestoreFromMemento(ByVal memento As IMilestoneMemento)
        model.RestoreFromMemento(memento)
    End Sub
End Class 'MilestoneMementoManager 